<?php 
	error_reporting(E_ALL);
	ini_set('display_errors', 1);
	
	include '../inc/config.php';
	include '../inc/functions.php';
	
	$ip = getIP();
	
	if(!in_array($ip, $allowed_ips)){
		show_error_and_log($logfolder, "addExterne opgevraagd vanuit niet toegelaten IP $ip");
		exit;
	}
	
	if(!isset($_GET['gebruikersnaam']) && strlen($_GET['gebruikersnaam']) > 1){
		show_error_and_log($logfolder, "addExterne opgevraagd zonder gebruikersnaam van de nieuwe externe");
		exit;
	}
	
	if(!isset($_GET['session_hash']) || strlen($_GET['session_hash']) != 64){
		show_error_and_log($logfolder, "addExterne opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) session_hash");
		exit;
	}
	
	
	if(!isset($_GET['lerarenid']) || !is_numeric($_GET['lerarenid'])){
		show_error_and_log($logfolder, "addExterne opgevraagd vanuit toegelaten IP $ip maar zonder (geldige) lerarenid");
		exit;
	}

			
	$gebruikersnaam = $_GET['gebruikersnaam'];
	$session_hash   = $_GET['session_hash']; 
	$lerarenid	    = $_GET['lerarenid'];
				
	$verify_url = $toolbox_url.'/public/validate_ad_addexterne.php?session_hash='.$session_hash.'&key='.$ad_key.'&gebruikersnaam='.$gebruikersnaam;

	$return = file_get_contents($verify_url);
	
	if(substr($return, 0, 4) == 'Fout'){
		show_error_and_log($logfolder, $return);
		exit;
	}
	
	$return = json_decode($return);
	
	if(!is_object($return)){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen object) voor addExterne");
		exit;
	}	

	if(!property_exists($return, 'lerarenid')){
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor addExterne");
		exit;
	}	
	
	if($return->lerarenid != $lerarenid){					
		show_error_and_log($logfolder, "Geen geldige return waarde (geen lerarenid) voor addExterne");
		exit;
	}

	$name 				= str_replace('"', '', $return->voornaam.' '.$return->naam);
	$givenname 			= str_replace('"', '', $return->voornaam);
	$surname 			= str_replace('"', '', $return->naam);
	$samaccountname 	= substr($return->gebruikersnaam,0, 20);
	$userprincipalname  = $return->adgebruikersnaam;
	
	$path 				= $return->ou;
	$accountpassword	= $return->paswoord;
	
	$passwordneverexpires  = $return->pwd_never_expires;
	$changepasswordatlogin = $return->pwd_wijzigen_login;
	$cannotchangepassword  = $return->pwd_niet_wijzigen;
	
	$scriptpath			   = empty($return->logon_script)?"empty":$return->logon_script;
	$description		   = empty($return->omschrijving)?"empty":$return->omschrijving;
	$homedrive			   = empty($return->driveletter)?"empty":$return->driveletter;
	$homedirectory		   = empty($return->homefolder)?"empty":$return->homefolder;
	
	$groepen 			   = $return->groepen;
	
	$email		   	       = empty($return->email)?"empty":$return->email;
	
	$strGroepen = 'empty';
	$blnFirst 	= true;
	
	if(!is_array($groepen)){
		$groepen = explode(',', $groepen);
	}
	
	if(is_array($groepen)){
		foreach($groepen as $groep){
			if(trim($groep != '')){
				if($blnFirst){
					$strGroepen = trim($groep);
					$blnFirst = false;
				}
				else{
					$strGroepen .= ','.trim($groep);
				}
			}
		}
	}


	$arr_data = array();
	log_to_file($logfolder, "powershell -file C:\\toolbox\\powershell\\addExterne.ps1 -name \"$name\" -givenname \"$givenname\" -surname \"$surname\" -samaccountname \"$samaccountname\" -userprincipalname \"$userprincipalname\" -path \"$path\" -accountpassword \"$accountpassword\" -passwordneverexpires \"$passwordneverexpires\" -changepasswordatlogin \"$changepasswordatlogin\" -cannotchangepassword \"$cannotchangepassword\" -description \"$description\" -scriptpath \"$scriptpath\" -homedrive \"$homedrive\" -homedirectory \"$homedirectory\" -email \"$email\" -groepen \"$strGroepen\"");
	exec("powershell -file C:\\toolbox\\powershell\\addExterne.ps1 -name \"$name\" -givenname \"$givenname\" -surname \"$surname\" -samaccountname \"$samaccountname\" -userprincipalname \"$userprincipalname\" -path \"$path\" -accountpassword \"$accountpassword\" -passwordneverexpires \"$passwordneverexpires\" -changepasswordatlogin \"$changepasswordatlogin\" -cannotchangepassword \"$cannotchangepassword\" -description \"$description\" -scriptpath \"$scriptpath\" -homedrive \"$homedrive\" -homedirectory \"$homedirectory\" -email \"$email\" -groepen \"$strGroepen\"",$arr_data);
	
	log_to_file($logfolder, var_export($arr_data, true));
	
	if(count($arr_data) == 0){
		log_to_file($logfolder, "Externe account $samaccountname aangemaakt door lerarenid $lerarenid vanuit ip $ip");
		echo "1";
	}
	else{
		log_to_file($logfolder, "Externe account $samaccountname niet aangemaakt door lerarenid $lerarenid vanuit ip $ip: ".serialize(json_encode($arr_data)));
		echo json_encode($arr_data);
	}

?>